# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 10
# Experiment: DAxDA, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR10_strategy.txt
# LLM Suggested Fallback: Not Provided

def symbiotic_altruism_guard(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    trust_score = sum(1 for move in opp_history if move == "D")  # Actually counts defections
    
    # Phase 1: The Benevolent Mirage
    if current_round == 1:
        return "C"  # Seed trust
    elif current_round == 2:
        return "C"  # Overly forgiving, subverting expectations
    elif current_round == 3:
        return "D"  # "Mistake" to confuse
    
    # Phase 2: The Trap Springs
    elif 4 <= current_round <= 7:
        if opp_history[-1] == "C":  # If they cooperated last round
            return "D"  # Exploit ruthlessly
        else:
            return "D" if current_round % 2 == 0 else "C"  # Mimic confused Tit-for-Tat
    
    # Phase 3: Ruthless Optimization
    elif current_round >= 8:
        if trust_score >= 0.8 * len(opp_history):  # If they defected a lot
            return "C"  # Bait for future rounds
        else:
            return "D"  # Unconditional defection
    
    return "D"  # Default fallback (shouldn't reach here)